package gov.va.med.mhv.admin.repository;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class UserProfileDynamicQueryRepository implements Serializable {

	private static final long serialVersionUID = 324589274837L;

	@PersistenceContext
    private EntityManager em;

	@SuppressWarnings("rawtypes")
	@Transactional
	public List getPatientInformation(String queryStr, Map<String, Object> values) {
    	Query query = em.createQuery(queryStr);
		populateQuery(query, values);
        return query.getResultList();
    }

	private void populateQuery(Query query, Map<String, Object> values) {
		for (Iterator<Map.Entry<String, Object>> iter = values.entrySet().
                iterator();
             iter.hasNext();)
        {
			Map.Entry<String, Object> i = iter.next();
			String key = i.getKey();
			Object value = i.getValue();
			query.setParameter(key, value);
		}
	}

}